/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.imgcontrol;

import com.quantumdata.imgcontrol.ColorControl;
import com.quantumdata.imgcontrol.ImageControlPage;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.widgets.QDCheckBox;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CheckBase
extends ImageControlPage
implements ChangeListener,
ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    private ColorControl m_color1;
    private ColorControl m_color2;
    private QDCheckBox m_grayScale;
    private JTextField m_checkSize;
    private JSpinner m_spin;
    private JTextField m_checkSize2;
    private JSpinner m_spin2;
    private QDCheckBox m_square;
    private boolean m_isSquare = false;
    private String m_nName;
    private String m_nName2 = null;
    private int m_minN;
    private int m_maxN;
    private GridBagLayout m_layout;
    private QDPanel m_panel;

    public CheckBase(String string, String string2, String string3, String string4, int n, int n2, String string5) {
        super(string);
        this.m_minN = n;
        this.m_maxN = n2;
        this.m_nName = string5;
        this.m_layout = new GridBagLayout();
        this.m_panel = new QDPanel(this.m_layout);
        this.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.m_color1 = new ColorControl(string2);
        this.m_color1.addChangeListener(this);
        this.m_layout.setConstraints(this.m_color1, gridBagConstraints);
        this.m_panel.add(this.m_color1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.m_color2 = new ColorControl(string3);
        this.m_color2.addChangeListener(this);
        this.m_layout.setConstraints(this.m_color2, gridBagConstraints);
        this.m_panel.add(this.m_color2);
        this.m_grayScale = new QDCheckBox("Gray Scale Mode");
        this.m_grayScale.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.m_layout.setConstraints(this.m_grayScale, gridBagConstraints);
        this.m_panel.add(this.m_grayScale);
        QDPanel qDPanel = new QDPanel();
        this.m_checkSize = new JTextField(4);
        this.m_checkSize.addActionListener(this);
        this.m_checkSize.addFocusListener(this);
        QDLabel qDLabel = new QDLabel(string4 + ": ");
        qDPanel.add(qDLabel);
        qDPanel.add(this.m_checkSize);
        this.m_spin = new JSpinner();
        this.m_spin.setEditor(this.m_checkSize);
        this.m_spin.addChangeListener(this);
        qDPanel.add(this.m_spin);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.m_layout.setConstraints(qDPanel, gridBagConstraints);
        this.m_panel.add(qDPanel);
        this.add((Component)new JScrollPane(this.m_panel), "Center");
    }

    protected void addSecondSize(String string, String string2) {
        this.m_nName2 = string2;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        QDPanel qDPanel = new QDPanel();
        this.m_checkSize2 = new JTextField(4);
        this.m_checkSize2.addActionListener(this);
        this.m_checkSize2.addFocusListener(this);
        QDLabel qDLabel = new QDLabel(string + ": ");
        qDPanel.add(qDLabel);
        qDPanel.add(this.m_checkSize2);
        this.m_spin2 = new JSpinner();
        this.m_spin2.setEditor(this.m_checkSize2);
        this.m_spin2.addChangeListener(this);
        qDPanel.add(this.m_spin2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.m_layout.setConstraints(qDPanel, gridBagConstraints);
        this.m_panel.add(qDPanel);
        this.m_square = new QDCheckBox("Square Checks");
        this.m_square.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.m_layout.setConstraints(this.m_square, gridBagConstraints);
        this.m_panel.add(this.m_square);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.m_spin || changeEvent.getSource() == this.m_spin2) {
            JSpinner jSpinner = (JSpinner)changeEvent.getSource();
            int n = (Integer)jSpinner.getValue();
            if (n < this.m_minN) {
                n = this.m_minN;
                jSpinner.setValue(new Integer(n));
                return;
            }
            if (n > this.m_maxN) {
                n = this.m_maxN;
                jSpinner.setValue(new Integer(n));
                return;
            }
            this.setCheckSize(n, true, jSpinner == this.m_spin ? 1 : 2);
        } else {
            try {
                CheckBase.sendCmd("XIMG:PARM " + this.getImageName() + " CLR1 " + this.m_color1.getColorText());
                CheckBase.sendCmd("XIMG:PARM " + this.getImageName() + " CLR2 " + this.m_color2.getColorText());
            }
            catch (InstrumentException instrumentException) {
                return;
            }
        }
    }

    protected void readAll() throws InstrumentException {
        String string = CheckBase.sendCmd("XIMG:PARM? " + this.getImageName() + " CLR1");
        this.m_color1.setColor(string);
        string = CheckBase.sendCmd("XIMG:PARM? " + this.getImageName() + " CLR2");
        this.m_color2.setColor(string);
        this.setCheckSize(CheckBase.getInt("XIMG:PARM? " + this.getImageName() + " " + this.m_nName), false, 1);
        if (this.m_nName2 != null) {
            this.setCheckSize(CheckBase.getInt("XIMG:PARM? " + this.getImageName() + " " + this.m_nName2), false, 2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_checkSize || actionEvent.getSource() == this.m_checkSize2) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            int n = Integer.parseInt(jTextField.getText());
            if (n < this.m_minN) {
                n = this.m_minN;
            }
            if (n > this.m_maxN) {
                n = this.m_maxN;
            }
            this.setCheckSize(n, false, jTextField == this.m_checkSize ? 1 : 2);
            jTextField.selectAll();
        } else if (actionEvent.getSource() == this.m_grayScale) {
            boolean bl = !this.m_color1.getGrayScaleMode();
            this.m_color1.setGrayScaleMode(bl);
            this.m_color2.setGrayScaleMode(bl);
        } else if (actionEvent.getSource() == this.m_square) {
            boolean bl = this.m_isSquare = !this.m_isSquare;
            if (this.m_isSquare) {
                int n = Integer.parseInt(this.m_checkSize.getText());
                this.setCheckSize(n, false, 1);
            }
        }
    }

    protected void setCheckSize(int n, boolean bl, int n2) {
        try {
            String string = Integer.toString(n);
            if (n2 == 1) {
                this.m_checkSize.setText(string);
                this.m_spin.setValue(new Integer(n));
                if (bl) {
                    CheckBase.sendCmd("XIMG:PARM " + this.getImageName() + " " + this.m_nName + " " + string);
                }
                if (this.m_isSquare) {
                    this.m_isSquare = false;
                    this.setCheckSize(n, bl, 2);
                    this.m_isSquare = true;
                }
            } else if (n2 == 2) {
                this.m_checkSize2.setText(string);
                this.m_spin2.setValue(new Integer(n));
                if (bl) {
                    CheckBase.sendCmd("XIMG:PARM " + this.getImageName() + " " + this.m_nName2 + " " + string);
                }
                if (this.m_isSquare) {
                    this.m_isSquare = false;
                    this.setCheckSize(n, bl, 1);
                    this.m_isSquare = true;
                }
            }
        }
        catch (InstrumentException instrumentException) {
            return;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof JTextField) {
            ((JTextField)focusEvent.getSource()).selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

